## Definition and Purpose

- **Virtual Private Network (VPN)**: Secures communication across untrusted networks.
    - **RFC 2828 Definition**: A logical network constructed from public network resources, often using encryption and tunneling.
    - **Components**:
        - **Virtual**: Logical networks, independent of physical architecture.
        - **Private**: Independent of IP addressing, ensuring confidentiality and message integrity.
        - **Network**: Interconnected computers and devices sharing information.

## Basic VPN Deployment Models

- **Purpose**: Carry private traffic over public/shared infrastructures like the internet.
- **Technology**: Typically uses IPsec or SSL/TLS to secure communications at the network layer.
    - **Transparency**: Network layer VPNs are transparent to higher OSI layer applications and independent of network topology.

## VPN Classification

- **Deployment Mode**:
    - **Site-to-Site VPN**: Connects branch offices, home offices, or business partners over the internet.
    - **Remote-Access VPN**: Provides secure remote access to networks and applications, established via VPN client software or SSL-enabled web browsers.
- **Underlying Technology**:
    - **IP Security (IPsec) VPN**
    - **SSLVPN**
    - **Multiprotocol Label Switching (MPLS) VPN**
    - **Other Layer 2 Technologies**: Frame Relay, ATM
    - **Hybrid VPNs**: Combining multiple technologies

## Encryption in VPNs

- **Purpose**: Address security issues of cleartext data transmission.
    - **Cleartext Data**: Information that can be easily understood (e.g., Telnet, FTP, TFTP, POP, SMTP).
- **Process**:
    - **Encryption**: Converts data to ciphertext, making it unreadable except to the intended recipient.
    - **Decryption**: Reverses encryption to restore original data.

## Cryptographic VPN Requirements

- **Confidentiality**: Ensures only the intended recipient can read data.
- **Origin Authentication**: Confirms legitimacy of endpoint entities.
- **Data Integrity**: Guarantees data has not been altered during transit.

## Features and Devices

- **Site-to-Site and Remote-Access VPN**: Features typically available on routers and firewalls.

